import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { CheckCircle2, LayoutDashboard, Target, Users, BarChart3, ArrowRight } from "lucide-react";
import logoImg from "@assets/Looking_For-removebg-preview_1768739801551.png";

export default function LandingPage() {
  return (
    <div className="min-h-screen bg-background flex flex-col">
      {/* Navigation */}
      <nav className="border-b bg-background/95 backdrop-blur sticky top-0 z-50">
        <div className="container mx-auto px-4 h-22 flex items-center justify-between gap-4">
          <div className="flex h-16 w-56 items-center overflow-hidden">
            <img src={logoImg} alt="Logo" className="h-full w-full object-contain" />
          </div>
          <div className="flex items-center gap-4">
            <Button variant="ghost" asChild>
              <a href="/api/login">Sign In</a>
            </Button>
            <Button asChild>
              <a href="/api/login">Get Started</a>
            </Button>
          </div>
        </div>
      </nav>

      {/* Hero Section */}
      <section className="py-20 lg:py-32 overflow-hidden bg-gradient-to-b from-primary/5 to-background">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="space-y-8">
              <div className="space-y-4">
                <h1 className="text-4xl lg:text-6xl font-bold tracking-tight leading-tight">
                  Master Your Sales Pipeline with Precision
                </h1>
                <p className="text-xl text-muted-foreground max-w-lg leading-relaxed">
                  The all-in-one CRM designed to capture leads, track deals, and accelerate your growth with powerful analytics.
                </p>
              </div>
              <div className="flex flex-col sm:flex-row gap-4">
                <Button size="lg" className="h-12 px-8 text-lg group" asChild>
                  <a href="/api/login">
                    Start Free Trial
                    <ArrowRight className="ml-2 h-5 w-5 group-hover:translate-x-1 transition-transform" />
                  </a>
                </Button>
                <Button size="lg" variant="outline" className="h-12 px-8 text-lg" asChild>
                  <a href="/lead-form">View Public Form</a>
                </Button>
              </div>
              <div className="flex items-center gap-6 text-sm text-muted-foreground">
                <div className="flex items-center gap-2">
                  <CheckCircle2 className="h-4 w-4 text-primary" />
                  No credit card required
                </div>
                <div className="flex items-center gap-2">
                  <CheckCircle2 className="h-4 w-4 text-primary" />
                  Free forever plan
                </div>
              </div>
            </div>
            <div className="relative lg:ml-8">
              <div className="absolute -inset-4 bg-primary/20 rounded-xl blur-2xl animate-pulse" />
              <Card className="relative border shadow-2xl overflow-hidden rounded-xl bg-background/50 backdrop-blur">
                <CardContent className="p-0">
                  <div className="bg-muted h-8 flex items-center gap-1.5 px-4 border-b">
                    <div className="w-3 h-3 rounded-full bg-destructive/50" />
                    <div className="w-3 h-3 rounded-full bg-yellow-500/50" />
                    <div className="w-3 h-3 rounded-full bg-green-500/50" />
                  </div>
                  <div className="p-6 space-y-6">
                    <div className="flex items-center justify-between">
                      <div className="h-4 w-32 bg-muted rounded animate-pulse" />
                      <div className="h-8 w-8 bg-muted rounded-full animate-pulse" />
                    </div>
                    <div className="grid grid-cols-3 gap-4">
                      <div className="h-24 bg-muted rounded animate-pulse" />
                      <div className="h-24 bg-muted rounded animate-pulse" />
                      <div className="h-24 bg-muted rounded animate-pulse" />
                    </div>
                    <div className="space-y-3">
                      <div className="h-4 w-full bg-muted rounded animate-pulse" />
                      <div className="h-4 w-5/6 bg-muted rounded animate-pulse" />
                      <div className="h-4 w-4/6 bg-muted rounded animate-pulse" />
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Features Grid */}
      <section className="py-24 bg-background">
        <div className="container mx-auto px-4">
          <div className="text-center space-y-4 mb-16">
            <h2 className="text-3xl font-bold tracking-tight">Everything you need to scale</h2>
            <p className="text-muted-foreground text-lg max-w-2xl mx-auto">
              Built by sales experts for modern teams who want to close more deals with less friction.
            </p>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            {[
              {
                title: "Opportunities",
                desc: "Drag-and-drop Kanban board to track deals through custom stages.",
                icon: Target
              },
              {
                title: "Smart Analytics",
                desc: "Real-time dashboards showing conversion rates and sales performance.",
                icon: BarChart3
              },
              {
                title: "Lead Management",
                desc: "Automatically capture prospects via customizable web forms.",
                icon: LayoutDashboard
              },
              {
                title: "Contact Registry",
                desc: "Centralized database for all customer information and history.",
                icon: Users
              }
            ].map((feature, i) => (
              <Card key={i} className="hover-elevate transition-all border-none bg-muted/50">
                <CardContent className="p-6 space-y-4">
                  <div className="h-12 w-12 rounded-lg bg-primary/10 flex items-center justify-center">
                    <feature.icon className="h-6 w-6 text-primary" />
                  </div>
                  <h3 className="font-semibold text-xl">{feature.title}</h3>
                  <p className="text-muted-foreground leading-relaxed">
                    {feature.desc}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="border-t py-12 bg-muted/30 mt-auto">
        <div className="container mx-auto px-4 text-center text-muted-foreground">
          <div className="flex h-14 w-56 items-center mx-auto mb-6 opacity-50 grayscale hover:grayscale-0 transition-all">
            <img src={logoImg} alt="Logo" className="h-full w-full object-contain" />
          </div>
          <p>© 2026 Selling A Home Made Easy. All rights reserved.</p>
        </div>
      </footer>
    </div>
  );
}
