import { useLocation, Link } from "wouter";
import { 
  LayoutDashboard, 
  Users, 
  Handshake, 
  FileInput, 
  BarChart3,
  Target,
  LogOut
} from "lucide-react";
import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupContent,
  SidebarGroupLabel,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
  SidebarHeader,
  SidebarFooter,
} from "@/components/ui/sidebar";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { useAuth } from "@/hooks/use-auth";
import logoImg from "@assets/Looking_For-removebg-preview_1768739801551.png";

const navItems = [
  { title: "Dashboard", url: "/", icon: LayoutDashboard },
  { title: "Opportunities", url: "/pipeline", icon: Target },
  { title: "Leads", url: "/leads", icon: FileInput },
  { title: "Contacts", url: "/contacts", icon: Users },
  { title: "Deals", url: "/deals", icon: Handshake },
  { title: "Analytics", url: "/analytics", icon: BarChart3 },
];

export function AppSidebar() {
  const [location] = useLocation();
  const { user } = useAuth();

  return (
    <Sidebar>
      <SidebarHeader className="border-b border-sidebar-border px-4 py-4">
        <Link href="/" className="flex items-center">
          <div className="flex h-18 w-60 items-center justify-center overflow-hidden">
            <img src={logoImg} alt="Logo" className="h-full w-full object-contain" />
          </div>
        </Link>
      </SidebarHeader>
      <SidebarContent>
        <SidebarGroup>
          <SidebarGroupLabel>Navigation</SidebarGroupLabel>
          <SidebarGroupContent>
            <SidebarMenu>
              {navItems.map((item) => (
                <SidebarMenuItem key={item.title}>
                  <SidebarMenuButton 
                    asChild
                    isActive={location === item.url || (item.url !== "/" && location.startsWith(item.url))}
                  >
                    <Link href={item.url} data-testid={`link-nav-${item.title.toLowerCase()}`}>
                      <item.icon className="h-4 w-4" />
                      <span>{item.title}</span>
                    </Link>
                  </SidebarMenuButton>
                </SidebarMenuItem>
              ))}
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>
      </SidebarContent>
      <SidebarFooter className="border-t border-sidebar-border p-4 gap-4 flex flex-col">
        {user && (
          <div className="flex items-center gap-3 px-2 py-1">
            <Avatar className="h-8 w-8">
              <AvatarImage src={user.profileImageUrl || undefined} />
              <AvatarFallback className="bg-primary/10 text-primary">
                {user.firstName?.[0]}{user.lastName?.[0]}
              </AvatarFallback>
            </Avatar>
            <div className="flex-1 min-w-0">
              <p className="text-sm font-medium truncate">
                {user.firstName} {user.lastName}
              </p>
              <p className="text-xs text-muted-foreground truncate">
                {user.email}
              </p>
            </div>
          </div>
        )}
        <div className="flex flex-col gap-2">
          <Link 
            href="/lead-form" 
            className="flex items-center gap-2 text-sm text-muted-foreground hover:text-foreground transition-colors px-2"
            data-testid="link-public-lead-form"
          >
            <FileInput className="h-4 w-4" />
            <span>Public Lead Form</span>
          </Link>
          <a 
            href="/api/logout" 
            className="flex items-center gap-2 text-sm text-muted-foreground hover:text-destructive transition-colors px-2"
            data-testid="link-logout"
          >
            <LogOut className="h-4 w-4" />
            <span>Logout</span>
          </a>
        </div>
      </SidebarFooter>
    </Sidebar>
  );
}
